// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntitySub.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntitySub.h"
#include "EntityParticle.h"
#include "Level.h"
#include "Application.h"




EntitySub::EntitySub()
{

  SetFrame( Dobbs::ANIM_SUB_EMPTY );
  m_Floating = true;
  m_DisplayOffset.x = 32;
  m_DisplayOffset.y = 32;
  SetRect( &m_CollisionRect, -24, -24, 23, 23 );
  m_BubbleDelay = 1.0f;

}



EntitySub::~EntitySub() 
{
}



void EntitySub::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_DIE:
      break;
    case EE_DROP:
      SetFrame( Dobbs::ANIM_SUB_EMPTY );
      SetVelX( 0.0f );
      SetVelY( 0.0f );
      g_App.StopSound( "Sub.Motor" );
      break;
    case EE_BLOCKED_TOP:
      // is the sub moved outside the water, if possible, the player might want to exit
      if ( !m_CarriedEntities.empty() )
      {
        RECT    RCPlayer = m_pLevel->m_pPlayer->CollisionRect();
        RECT    RCPlayerOrig = RCPlayer;
        OffsetRect( &RCPlayer, 0, -48 );
        if ( ( !m_pLevel->IsAreaBlocked( m_pLevel->m_pPlayer, RCPlayerOrig, Dobbs::DIR_UP ) )
        &&   ( !m_pLevel->IsAreaBlocked( m_pLevel->m_pPlayer, RCPlayer, Dobbs::DIR_UP ) )
        &&   ( !m_pLevel->IsAreaDeadly( m_pLevel->m_pPlayer, RCPlayer, Dobbs::DIR_UP ) ) )
        {
          DropOff( m_pLevel->m_pPlayer );
          while ( ( m_pLevel->TileFromLayer( 2, m_X / 32, m_Y / 32 ) == Dobbs::TILE_WATER )
          ||      ( m_pLevel->TileFromLayer( 2, m_X / 32, m_Y / 32 ) == Dobbs::TILE_WATER_TOP ) )
          {
            m_pLevel->Move( this, 0, -15, Dobbs::DIR_FORCED_MOVE );
          }
          m_pLevel->m_pGame->StoreSubPosition( GetX(), GetY() );
        }
      }
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntitySub::Update( Level& aLevel )
{

  Entity::Update( aLevel );

  m_VelX = 0.95f * m_VelX;
  m_VelY = 0.95f * m_VelY;

}



void EntitySub::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  Entity::UpdateTimed( aLevel, ElapsedTime );

  if ( m_CurrentAnimation != Dobbs::ANIM_SUB_EMPTY )
  {
    m_BubbleDelay -= ElapsedTime;
    if ( m_BubbleDelay <= 0.0f )
    {
      // spawn bubbles
      m_BubbleDelay = 0.1f + ( rand() % 20 ) * 0.01f;

      Dobbs::ParticleType   Type = Dobbs::BUBBLE_SMALL;
      if ( ( rand() % 3 ) == 0 )
      {
        Type = Dobbs::BUBBLE_BIG;
      }
      EntityParticle* pParticle = aLevel.SpawnParticle( Type, m_X, m_Y + 30 );
      pParticle->SetLifeTime( 0.6f + ( rand() % 20 ) * 0.01f );
    }
  }

}